﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace GraphicChart.PieChart
{
    /// <summary>
    /// Trieda ktora vykresluje 2D kolacove grafy
    /// </summary>
    public class PieChart2D
    {


        private Grid g;                                     // grid kde sa ma vykreslovat graf
        private List<string> s1;                            // tu je ulozeny list stringov pre selekciu, teda ak sa kliklo na nejekay obdlznik
        private List<string> sort;                          // tu je ulozeny list stringov pre selekciu ak sa sortovalo "1a" graf 1 ascending
        private Canvas c;                                   // kanvas pre vykreslovanie grafov
        private Core.ChartVariables cv;                     // vsetky premenne grafu
        private List<List<string>> data;                    // datovy zdroj grafu
        private List<string> dataX = new List<string>();    // data pre Xovu os
        private List<double> dataY = new List<double>();    // data pre Yovu os
        private IEnumerable<Core.ChartVariables> ess;       // vsetky premenne pre vsetky grafy


        /// <summary>
        /// Vykreslenie grafu
        /// </summary>
        public PieChart2D(List<string> sort1, List<string> s, Grid g1, Core.ChartVariables cv1, List<List<string>> data1, IEnumerable<Core.ChartVariables> es1)
        {
            g = g1;
            s1 = s;
            cv = cv1;
            data = data1;
            sort = sort1;
            ess = es1;

            // pripravi a vrati data
            Core.PrepareData prepareData = new Core.PrepareData(data, s1, cv, sort);
            dataX = prepareData.ReturnDataX();
            dataY = prepareData.ReturnDataY();

            // naincializovanie a vytvorenie grafu
            c = new Canvas();
            c.SetValue(Grid.VerticalAlignmentProperty, VerticalAlignment.Bottom);
            Core.InsertChartToGrid insertToGrid = new Core.InsertChartToGrid(c, cv);
            c.Width = cv.ChartWidth;
            c.Height = cv.ChartHeight;
            c.Background = new SolidColorBrush(Colors.White);
            g.Children.Add(c);

            // vytvorenie mriezky a popiskov
            Core.PieDraw pd = new Core.PieDraw(sort, s1, g, c, cv, dataX, dataY, data, ess);
        }
    }
}
